

#include <iostream.h>
#include <fstream.h>
#include<time.h>
#include<stdlib.h>
#include <math.h>

const int max_tasks = 100;
const int max_chromos =410; // 4 times the maximum number of jobs
// const int cost_index = 100;

struct val_index{
	int value;
	int index;
};

enum gene_type {duration, due_date_duration, random_key};
fstream randomkey_data("randomkey.data", ios::out);
fstream duration_data("duration.data", ios::out);
// fstream anneal_data("anneal.data", ios::out);
fstream log_data("log.data", ios::out);
fstream file_out ("tc.data", ios::out);
fstream jump_out("jmp.data", ios::out);

class job_list
{
private:
	struct list_item{
		int job;
		int duration;
		int difference;
		list_item * next_ptr; };
	list_item * root;

	// returns the absolute difference of the parameters 
	int  abs_diff(int x, int y)
	{ if (x > y) return (x-y);
	  else return (y-x);}

public:
	job_list() { root = NULL;}
	void add_item (int job_number, int duration);
	void delete_item (int job_number);
	void print_list();
	int match_with (int duration);
};

void job_list:: add_item(int job_number, int duration)
{  list_item * ptr;
// add the item at the beginning of the list
	ptr = new list_item;
	ptr->job = job_number;
	ptr->duration = duration;
	ptr->next_ptr = root;

	root = ptr;
}
	
int job_list:: match_with(int duration)
{  list_item *ptr = root, * closest_ptr;

	if (root == NULL)
	{ cout << " list is null and there is nothing to match with " << endl;
	  exit (0);}
	while (ptr != NULL)
	{ 	ptr->difference = abs_diff(ptr->duration, duration);
		ptr = ptr ->next_ptr;}

	closest_ptr = root;
	ptr = root->next_ptr;
	while(ptr != NULL)
	{	if (ptr->difference < closest_ptr->difference)
			closest_ptr = ptr;
		ptr = ptr->next_ptr;
	}
	return(closest_ptr->job);
}

void job_list:: delete_item (int job_number)
{ list_item *ptr, *look_ahead;
  enum status {yes, no};
  status found = no;

// check to see the job_number is in the root item
	if (root->job == job_number)
	{	ptr = root;
		root = root->next_ptr;
		delete ptr;
		found = yes;}
	ptr = root;

	if(root != NULL) look_ahead = root->next_ptr;
	else look_ahead = NULL;

	while ( (look_ahead != NULL) && found != yes)
	{	if (look_ahead ->job == job_number)
		{	ptr->next_ptr = look_ahead->next_ptr;
			delete look_ahead;
			found = yes;}
		else
		{	ptr = look_ahead;
			look_ahead = ptr ->next_ptr;
		}
	}
}

void job_list:: print_list()
{ list_item *ptr = root;

	while (ptr != NULL)
	{ cout << " job " << ptr->job <<" with duration "<< ptr->duration << endl;
	  ptr = ptr -> next_ptr;}
}



void swap(val_index &x, val_index &y)
{ val_index temp;
	temp = x;
	x = y;
	y = temp;
}

void qsort (val_index a[], int left, int right)
{	int pivot, i, j;

	if (left <right)
	{
		pivot = a[(left+right)/2].value;
		i = left;
		j = right;

		for(;;)
		{	while (a[i].value < pivot) ++i;
			while (a[j].value >  pivot) --j;
			if (i < j)
			{	if (a[i].value != a[j].value) swap(a[i],a[j]);
				else --j;}
			else
				break;
		}
		qsort (a, left, i-1);
		qsort (a, i+1, right);
	}
}

// genetic class 

class genetic{

private:


int mating_pool_size; // pool size used in producing the off spring
int max_schedules; // pool size used in producing the off spring
int current_pool_size; //current pool size 
int best_cost; //best cost seen so far (ideally it is to be 0)
int rand_best_cost; //best cost of the randomly generated schedule
int worst_cost; // worst cost 
int rand_worst_cost; // worst cost of the randomly generated schedule
int best_schedule[max_tasks]; //best schedule associated with the best cost
int cost[max_tasks][3]; // cost[j][1] duration and cost[j][2] due date
int dur_factor ; // actual duration and the due date is multiplied by this factor
int init_chromos_pool[max_chromos][max_tasks];
int init_job_pool[max_chromos][max_tasks];
int chromos_pool[max_chromos][max_tasks];
int job_pool[max_chromos][max_tasks];
int seed_sch[max_tasks];
gene_type current_gene;
int jobs, genes, fitness_index, running_total_index;

// genes -- number of genes which is equal to the number of jobs
// fitness_index is the coloumn following the last gene
// running_total_index the index to the coloumn following the gene
// coloumn

int max(int x, int y)
{ if (x > y) return x;
  else return y;}
int pertabate()
{	if (jobs >10) return jobs/10;
	else return 1;}

void create_cost_matrix(int min_duration, int max_duration, int max_duedate);
void swap_pairs_randomly(int n,  int schedule[]);
void generate_seed_sch(int schedule[]);
int duplicate(int i, int index,  int *ptr);
void generate_job_pool(int pool_size);
void add_schedule_to_pool(int schedule[]);
void update_best_schedule(int , int *);
void mutate(); // mutate the a schedule from the new generation
void mate_a_pair();
void generation_update();
int select_parent();

public:

	genetic(int n, int min_dur, int max_dur, int max_due){
		
        // max_schedules =0;
		mating_pool_size = 2 * n;
		jobs= n;
		genes = n;
		fitness_index = genes +1; running_total_index = genes +2;
		dur_factor = 15; //duration and the due date is multiplied by this factor
		
		create_cost_matrix(min_dur, max_dur, max_due);

		}


	void generate_init_pool();
	void copy_pool (gene_type gene);
    int best_cost_so_far()
	{	return best_cost;}

	void anneal(float per_cost, float prob, char * file_name);
	void converge (float mute_per);
	void print_best_schedule ()
	{	print_schedule (best_schedule);}

    void print_schedule(int *);
			
	int cost_of_sch(int length, int sch[]);

	
	void random_schedules(int iterations);
	void print_job_pool();
	void print_chromos_pool();
	void print_cost_matrix();
	void write_cost_matrix();

}; // end of class

void genetic:: mutate()
{
// ramdomly pick up a schedule from the new generation (job_pool within
// mating_pool_size and the current_pool_size
// randomly pick up a job in the schedule and replace it with another job
// that is also randomly picked up. Then replace the new job in the schedule 
// with the old job

int i, temp, old_job_index, new_job_index, range, mute_sch;

	range = current_pool_size - mating_pool_size;

	mute_sch = rand() % range + mating_pool_size;
	old_job_index = rand() % jobs +1;
	new_job_index = rand() %jobs +1;
	while (new_job_index == old_job_index) new_job_index = rand()%jobs +1;

	
// swap the jobs at these indexes
	temp = job_pool[mute_sch][old_job_index];
	job_pool[mute_sch][old_job_index] = job_pool[mute_sch][new_job_index];
	job_pool[mute_sch][new_job_index] = temp; 



// make the changes into the chromos pool
	temp = chromos_pool[mute_sch][old_job_index];
	chromos_pool[mute_sch][old_job_index] = chromos_pool[mute_sch][new_job_index];
	chromos_pool[mute_sch][new_job_index] = temp;

// debug

//	cout << "muted schedule is at index "<< mute_sch << " job " << old_job_index << " is replaced
//	by "  << new_job_index << endl;

}


void genetic :: converge ( float mute_per)
{ int i,j, curr_best, prev_best, delta, iterations, mute_step, mate_count = 0, 
	mutations =0, total_iterations = 0; 

// mate_count keep track up number of mating done each time the converge routine
// is called
// mute_step number of mating between each muting and is equal to 100/mute_per
//
	
	mute_step = 100/mute_per;

	cout <<" The best cost found so far is " << (curr_best = best_cost_so_far()) << endl;
	cout << " the best schedule is " << endl;
	print_best_schedule();

	iterations = 2 * jobs ; // iterate twice the number of maximun jobs

	delta = curr_best; // delta is initialized to be the current best cost
	prev_best = curr_best;

	while (best_cost > rand_best_cost)
	{	
		for (i =1; i<= iterations; i++)
		{	mate_a_pair(); // mate k (jobs) number of pairs from chromoseoe
			++mate_count;
			total_iterations = total_iterations +2;
			if ((mate_count % mute_step) == 0) 
			{	mutate();
				++mutations;}
		}
		generation_update();
		curr_best = best_cost_so_far();
		delta = prev_best - curr_best;
		prev_best = curr_best;
		cout <<" completed one generation with delta " << delta << endl;
		cout <<" The total number of mutations are " << mutations << endl;
	}
	log_data <<" It took " << total_iterations <<" to converge to "<<
	rand_best_cost << endl;
}

int genetic:: duplicate(int i, int index,  int *ptr)
{ // to test whether i is a duplicate in the array from 1 to index
  // 

int j;

for (j=1; j < index; j++)
	if ( ptr[j] == i ) return 1;

return 0;
}

void genetic:: generate_seed_sch(int sch[])
{ int i,j;
// generate the initial schedule
for (i =1; i <= jobs; i++)
	sch[i] = i;

for (i =1; i <= jobs; i++)
	{ 	j =  rand() %(jobs+1);
		while (duplicate(j, i, sch) || j == 0 ) 
			j = rand()%(jobs+1); // generate random

		sch[i] = j;}
}

void genetic:: swap_pairs_randomly(int n,  int tour[])
{ // this will generate a sequence by swapping a  pair of 
  // jobs that are randomly picked up from 
int i, job1, job2, temp_val;

	
	for (i =1; i <= n; i++)
	{  job1 = (rand() % jobs) + 1;
	   job2 = (rand() % jobs) + 1;
           // check they are not the same
	   while (job1 == job2) job2 = (rand() % jobs) + 1;
           // swap job 1 and job 2
       	   temp_val = tour[job2];
	   tour[job2] = tour[job1];
	   tour[job1] = temp_val;
	   // debug
           // cout << " swapping " << job1 << "  and  " << job2 << endl;
	}
}




void genetic:: random_schedules(int iterations)
{ // generate random schedules by perturbing the current schedules
  // it also compute the best and the worst cost

  int j,k, cost, pertabation, best_count, worst_count;
  int current_sch[max_tasks];

	fstream random_data("random.data", ios::out);


	generate_seed_sch( seed_sch);
	//determine the number of pairs of pertabation 


	pertabation = pertabate();
	// debug
	cout <<" pertabation is set at "<< pertabation << endl;

	// initialse current_sch with the seed schedule
	for (k=1; k <=jobs; k++) current_sch[k] = seed_sch[k];
	rand_best_cost = cost_of_sch(jobs,current_sch);
	rand_worst_cost = 0;

  	for (j=1; j<= iterations; j++)
	{	
		swap_pairs_randomly(pertabation, current_sch);

		cost = cost_of_sch(jobs,current_sch);
		if (cost < rand_best_cost) 
		{	rand_best_cost = cost;
			best_count = j;}
		if (rand_worst_cost < cost) 
		{	rand_worst_cost = cost;
			worst_count = j;}

		random_data << cost << endl;

	}
	close ("random.data");
	log_data <<" Random pertabation created "<< endl;
	log_data <<" best cost " << rand_best_cost <<" was reached at iteration "<<
	best_count << endl;
	log_data << " worst cost "<< rand_worst_cost <<" was reached at iteration "<<
	worst_count << endl;

}

void genetic :: generate_init_pool()
{ //to generate initial job and chromosome pool using random numbers
  // chromos pool was generated using random numbers
  // job pool was created using random key encording that is
  //   sort thew chromosome with their index and the
  //   index of the sorted chromosome becomes the order
  //   of the jobs.

	int i,j;
	val_index order[max_chromos];

	current_pool_size = mating_pool_size;
	worst_cost = 0;

	for (i = 1; i <= mating_pool_size; i ++)
	{	for (j =1; j <= jobs; j++)
		{	init_chromos_pool[i][j] = rand() % (10* jobs) ;
			order[j].index = j;
			order[j].value = init_chromos_pool[i][j];
		}
		qsort (order, 1 , jobs);  //sort the chromosome
		for (j=1; j<=jobs; j++)
			init_job_pool[i][j] = order[j].index;
		init_job_pool[i][0] = cost_of_sch(jobs, init_job_pool[i]);
		if (worst_cost < init_job_pool[i][0])
			worst_cost = init_job_pool[i][0];
	}

	worst_cost = worst_cost + 1;
	// to give a chance to the chromosome with the worst cost

	// update fitness and the running cost 
	for (j=1; j<= mating_pool_size;j++)
	{	init_job_pool[j][fitness_index] = worst_cost - init_job_pool[j][0];
		if (j == 1)
			init_job_pool[j][running_total_index] = init_job_pool[j][fitness_index];
		else
			init_job_pool[j][running_total_index] = init_job_pool[j-1][running_total_index] + init_job_pool[j][fitness_index];

	}
} // end of generate init pool

void genetic :: copy_pool (gene_type gene)
{	// tocopy task pool and chromosome pool from init_job_pool
	// depending on the gene type

	int i,j;

	current_gene = gene;
	best_cost = 99999;
	// copy the job pool
	for (i =1; i <= mating_pool_size;i++)
	{	for (j=1; j <= jobs +2; j++)
			job_pool[i][j] = init_job_pool[i][j];
			
		job_pool[i][0] = init_job_pool[i][0];

		if (best_cost > job_pool[i][0])
			update_best_schedule(job_pool[i][0], job_pool[i]);
	}

	// copy or create the chromosome pool depending on the gene
	switch (gene){

	case random_key:
		for (i =1; i <= mating_pool_size;i++)
			for (j=1; j <= jobs; j++)
				chromos_pool[i][j] = init_chromos_pool[i][j];
		break;
	case duration:
		for (i =1; i <= mating_pool_size;i++)
			for (j=1; j <= jobs; j++)
				chromos_pool[i][j] = cost[job_pool[i][j]][1];
		break;

	case due_date_duration:
		for (i =1; i <= mating_pool_size;i++)
			for (j=1; j <= jobs; j++)
				chromos_pool[i][j] = cost[job_pool[i][j]][2] - cost[job_pool[i][j]][1];
		break;

	default:
		cout << " unrecognized gene type!!! " <<endl;  
		cout <<" gene must be duration, due_date_duration, or random key " <<endl;
	}
}




			

int genetic::select_parent()
{
// select a parent for mating using Roulette Wheel Parent Selection
// the running total index of the job pool has the running total

int index, rand_value, max_running_cost, RTindex = running_total_index;

	max_running_cost = job_pool[mating_pool_size][RTindex];
	rand_value = rand()%max_running_cost;
	index = rand_value * mating_pool_size / max_running_cost;
	if (index < 1) index =1; // set the lowest indes to 1

	if (job_pool[index][RTindex] >= rand_value) // scan upper chromosome 
	{	while((--index >= 1)  && (job_pool[index][RTindex] >= rand_value));
		return ++index;}
	else
	{	while((++index <= mating_pool_size) && (job_pool[index][RTindex] <rand_value));
		return index;}

}


void genetic::mate_a_pair()
{ // pick up a pair from the chromoseme pool and mate them
 //  using single cross over point selected randomly
    int xover_point, father, mother,i,j, job_num;
    int * child1, *child2;
	val_index order[max_chromos];
    job_list list1, list2;
    enum status {yes,no};
    status in_child1=no, in_child2=no;

	child1 = new int[jobs+1];
	child2 = new int[jobs+1];

    father = select_parent();
    mother = select_parent();
	while (father == mother) mother = select_parent();
    xover_point = rand()%jobs +1;
    while (xover_point == jobs) xover_point = rand()%jobs +1;

//debug
// cout <<father <<" f " << mother <<" m " <<xover_point << " x "<< endl;

	switch (current_gene)
	{
	case random_key:
		for (i =1; i<= xover_point; i ++)
		{	chromos_pool[current_pool_size +1][i] = chromos_pool[father][i];
			chromos_pool[current_pool_size +2][i] = chromos_pool[mother][i];}
		for (i = xover_point +1; i<= jobs; i ++)
		{	chromos_pool[current_pool_size +1][i] = chromos_pool[mother][i];
			chromos_pool[current_pool_size +2][i] = chromos_pool[father][i];}
		for (i = 1; i<= jobs; i ++)
		{	order[i].value = chromos_pool[current_pool_size +1][i];	
			order[i].index = i;}
		qsort(order,1, jobs);
		for (i = 1; i<= jobs; i ++)
			child1[i] = order[i].index;
		for (i = 1; i<= jobs; i ++)
		{	order[i].value = chromos_pool[current_pool_size +2][i];	
			order[i].index = i;}
		qsort(order,1, jobs);
		for (i = 1; i<= jobs; i ++)
			child2[i] = order[i].index;
		break;

	case duration: case  due_date_duration:

		for (i =1; i <= xover_point; i++)
		{	child1[i] = job_pool[father][i];
			child2[i] = job_pool[mother][i];
		}

		for (i =1 ; i <= jobs; i++)
		{ 	for (j = 1; j<=xover_point; j ++)
			{ 	if(child1[j] == i) in_child1 =yes;
				if(child2[j] == i) in_child2 =yes;}
			if (in_child1 != yes)
				list1.add_item(i, cost[i][1]); // enter the job number and its duration
      		if (in_child2 != yes)
                list2.add_item(i, cost[i][1]);
			in_child1=no; // initialise 
			in_child2=no;
		}


		for (i= xover_point +1; i <= jobs; i++)
		{	job_num = list1.match_with(chromos_pool[mother][i]);
			child1[i] = job_num;
			list1.delete_item(job_num); }

		for (i=xover_point +1; i <= jobs; i++)
		{	job_num   = list2.match_with(chromos_pool[father][i]);
			child2[i] = job_num;
			list2.delete_item(job_num); }
		break;

	default:
		cout << " not applicable gene for mating " << endl;
	};

	add_schedule_to_pool(child1);
	add_schedule_to_pool(child2);
}

void genetic:: add_schedule_to_pool(int schedule[])
{int i;
 
 // add the job list to the job pool and create the corresponding
 // chromosome pool


	++ current_pool_size;
	for (i =1; i <= jobs; i++)
		job_pool[current_pool_size][i] = schedule[i];
	// job_pool[current_pool_size][0] = cost_of_sch(jobs, schedule);

	// if (best_cost > job_pool[current_pool_size][0])
	// 		update_best_schedule(job_pool[current_pool_size][0], schedule);


	// update the chromosome pool

	switch (current_gene){
	
	case duration:

		for (i =1; i <= jobs; i++)
			chromos_pool[current_pool_size][i] = cost[schedule[i]][1];
		break;
	case due_date_duration:
		for (i =1; i <= jobs; i++)
			chromos_pool[current_pool_size][i] = cost[schedule[i]][2] -
													cost[schedule[i]][1];
		break;

	}
}

void genetic :: generation_update()
{	// This is to update the task and the chromosome pool to maintain
	// only  the stronger chromose
	//
	// The size of the pool is cut off at max_pool_size (2*jobs)
	// 
	// the entire job pool is sorted
	// from the sorted list temporary job list and the chromosome list are created
	// if there are more than one job sequence with the same cost the first one is taken
	// leaving the rest of the job sequence with the same cost
	// 

val_index order [max_chromos];
int i,j,k, prev_value, temp_pool[max_chromos][max_tasks],temp_chromos[max_chromos][max_tasks];
int front, back, index; // indices used to copy the job and chromosome pool

// compute the cost of the new generation

	for (i =mating_pool_size; i <=current_pool_size; i++)
		job_pool[i][0] = cost_of_sch(jobs, job_pool[i]);

// write the cost of the generated schedule into a file

	if (current_gene == random_key)
	{	 for (i =mating_pool_size; i <=current_pool_size; i++)
			randomkey_data << job_pool[i][0] << endl;}
	else  if (current_gene == duration) 
	{    for (i =mating_pool_size; i <=current_pool_size; i++) 
				duration_data << job_pool[i][0] << endl;}

//copy the value index pair into an array
	for (i =1; i <= current_pool_size; i++)
	{	order[i].value = job_pool[i][0];
		order[i].index = i; }
	qsort (order, 1 , current_pool_size); //sort the val-index array
	//copy the task pool in ascending order of 
	// initialize the previous value and copy the best cost
	
	update_best_schedule(job_pool[order[1].index][0], job_pool[order[1].index]);

	for (i=0; i <=jobs; i++)
	{	temp_pool[1][i] = job_pool[order[1].index][i];
		temp_chromos [1][i] = chromos_pool[order[1].index][i];}

	prev_value = job_pool[order[1].index][0];
	j=1;  //current pointer to the temp_pool
	for (i=2; i <= current_pool_size; i++)
	{	if (prev_value != job_pool[order[i].index][0]) // to avoid the job sequence
													   // with the same job cost
		{	++j;
			for (k=0; k<= jobs; k++)
			{	temp_pool[j][k] = job_pool[order[i].index][k];
				temp_chromos [j][k] = chromos_pool[order[i].index][k];}

			prev_value = job_pool[order[i].index][0];} //update the previous value
	}
	// copy the temp_pool back 
	if (j < mating_pool_size) mating_pool_size=j;
	current_pool_size = mating_pool_size;

	// the last element of the temp pool had the worst cost 

	worst_cost = temp_pool[mating_pool_size][0] +1;

	front = 1; 
	back = mating_pool_size;

// the ascending order of job spool is copied alternativelty front and
// the back of the jo pool and the chromosome pool

	for (i =1; i <= mating_pool_size; i ++)
	{	if (i % 2 != 0) index = front;
		else index = back;
		for (k=0; k<=jobs; k++)
		{	job_pool[index][k] = temp_pool[i][k];
			chromos_pool[index][k] = temp_chromos[i][k];}
		if (i % 2 != 0) ++front;
		else --back;
	}



	// update fitness and the running cost 

	for (j=1; j<= mating_pool_size; j++)
	{	job_pool[j][fitness_index] = worst_cost - job_pool[j][0];
		if (j == 1)
			job_pool[j][running_total_index] = job_pool[j][fitness_index];
		else
			job_pool[j][running_total_index] = job_pool[j-1][running_total_index] + job_pool[j][fitness_index];

	}



}


void genetic :: update_best_schedule( int curr_cost, int schedule[])
{ int i;
	best_cost = curr_cost;
	for (i =1; i <= jobs; i++)
		best_schedule[i] = schedule[i];
}

void genetic:: write_cost_matrix()
{int i;
fstream cm_out("cm.data", ios::out);
// open("cm.data");

for (i=1; i<= jobs; i++) 
	cm_out << cost[i][1]  << ' ' << cost[i][2] << endl;
} //end of write_cost_matrix


void genetic:: print_cost_matrix()
{int i;
for (i=1; i<= jobs + 2; i++) 
	cout << cost[i][1]  << ' '  << cost[i][2] << endl;
} //end of print_cost_matrix

void genetic:: print_job_pool()
{int i,j;
	// for (i=1; i<= mating_pool_size; i++) 
	for (i=1; i<= current_pool_size; i++) 
	{	for(j=0; j<=jobs +2 ; j++) //printing the cost of each schedule too
	    cout << job_pool[i][j]  << ' ';
		cout << endl;}
} //end of print_job_pool

void genetic:: print_chromos_pool()
{int i,j;
	for (i=1; i<= mating_pool_size; i++) 
	{	for(j=1; j<=jobs; j++)
	    cout << chromos_pool[i][j]  << ' ';
		cout << endl;}
} //end of print_chromos_pool


int genetic:: cost_of_sch(int length, int sched[])
{ int i, cur_job, time=0, total_cost =0;
	for (i=1; i <= length; i++)
	{	cur_job = sched[i];
		total_cost = total_cost + max(0, (time + cost[cur_job][1] - cost[cur_job][2]));
		time = time + cost[cur_job][1];
	}
	return total_cost/dur_factor;
}// 

void genetic::print_schedule(int * schedule)
{ int i,j, k;

k = jobs/10;
if (k > 1)
{ for (i=0; i < k; i++)
  { for(j=1; j<= 10; j ++) cout << schedule[i*10 + j] << "  " ;
    cout << endl;}
  for (j=k*10; j < jobs; j++) cout << schedule[j+1] << "  ";
}
else
   for(j=1; j <= jobs; j++) cout << schedule[j] << "  ";
cout << endl;
} // end of print tour
	





void genetic:: create_cost_matrix (int min_duration, int max_duration, int max_duedate)
{ int i, temp, dur_index, fact_min_dur, fact_max_duedate;

// cm [j,1] is the duration of the job j
// cm [j,2] is the due date of the job j
// duration and the due date will actually reflect the actual duration times the dur_factor
// the due date will reflect the actual due date times the dur factor

fact_min_dur = min_duration * dur_factor;
fact_max_duedate = max_duedate * dur_factor;

	dur_index = (max_duration - min_duration) * dur_factor;
	for (i = 1; i <= jobs; i++ )
	{	cost[i][1] = rand() % dur_index + fact_min_dur;
		temp = fact_max_duedate - cost[i][1];
		if (temp >0)
			cost[i][2] = rand() % temp + cost[i][1];
		else
			cost[i][2] = rand() % fact_max_duedate + cost[i][1];
	}
} //end of create cost matrix

	
//************** work on anneal *****************//

void genetic:: anneal (float per_cost, float prob, char * file_name)
{int cost, i,j, current_cost, best_cost, new_cost,jump_count=0, count = 0;
 int temp_sch[jobs +1], sch[jobs+1], pertabation, best_count;
 int init_cost, iterations, delta, temp_val, dec_cost, prev_best_cost;
 float threshold, temp_dec_factor = 10.;
 float Temp;


	fstream anneal_data(file_name, ios::out);

// accept higher cost of k% of initial cost with probability p k =50., p = 0.5;

	generate_seed_sch(sch);
	current_cost = cost_of_sch (jobs, sch);

// copy the tour into the best tour
	update_best_schedule(current_cost, sch);

 	best_cost = current_cost;
 	prev_best_cost = current_cost;
 	init_cost = current_cost;

// Suppose we would like to accept k% of the initial cost with the
// probability of p

	Temp = current_cost * (per_cost/100) / log(1/prob);

	iterations = jobs * jobs;

	pertabation = pertabate();
	
// itinalise the decrease in cost to the initianal cost
	dec_cost = current_cost;
	threshold = current_cost* per_cost/100;


	file_out <<Temp << "  " <<current_cost<< endl;

// debug
	cout <<"In annealing the best cost so far is "<< best_cost <<endl;
	cout <<"The best cost in random pertabation is "<< rand_best_cost << endl;

	while ( best_cost > rand_best_cost)
	{   for (i = 1; i <= iterations; i++)
    	{	for (j =1; j <= jobs; j++) temp_sch[j] = sch[j];
			
			++count; // track the total iterations

			swap_pairs_randomly(pertabation, temp_sch); 
			new_cost = cost_of_sch(jobs, temp_sch);

			if (new_cost < current_cost)
			{  for(j=1; j<= jobs; j++) sch[j] = temp_sch[j];
	   			current_cost = new_cost;
	   			file_out <<Temp << "  " <<current_cost<<  endl;
				anneal_data <<current_cost << endl;
       	   		if (best_cost > current_cost)
				{	best_cost = current_cost;
					best_count = count;
	   				update_best_schedule(best_cost, sch);}}
			else if ((delta = new_cost - current_cost) > 0)
			{  	if ( (rand()%1000) < ((1/exp(delta/Temp))*1000 ))
	   			{	current_cost = new_cost;
					// prev_best_cost = new_cost;
	  				for(j=1; j<= jobs; j++) sch[j] = temp_sch[j];
					anneal_data <<current_cost << endl;
					++jump_count;
	   				file_out <<Temp << "  " <<current_cost<<" iterations "<< count
					<< endl;
	        		jump_out <<Temp << "  " <<current_cost<<" jump count "
					<<jump_count << endl;
				}}
		} // end of the for loop
		Temp = Temp * ( 1 - temp_dec_factor/100);
	} // end of while loop

	log_data <<"The best cost of "<< best_cost <<" is reached "<<
	count <<" iteration with annealing "<< endl;


} // end of anneal 

		
void get_inputs(int & length, int & min_dur, int & max_dur, int & max_due, 
float &mute_per)
{

  cout << " Enter the number of Jobs" << endl ;
  cin >> length;
  cout << " Enter the minimum duration of the jobs " << endl;
  cin >> min_dur;
  cout << " Enter the maximum duration of the jobs " << endl;
  cin >> max_dur;
  cout << " Enter the maximum due date of the jobs " << endl;
  cin >> max_due;
  cout << " What is the mutation percentage " << endl;
  cin >> mute_per;
  

} //get inputs



void main(){
int i, j,length, min_dur, max_dur, max_due, iterations, option, trials;
float  mute_per, per_cost, prob;
int *sch , *orig_sch, repeates ;
char annealdata[11][20]={" ", "anneal1.data", "anneal2.data","anneal3.data",
	"anneal4.data","anneal5.data", "anneal6.data", "anneal7.data",
	"anneal8.data","anneal9.data", "anneal10.data"};


	srand((unsigned) time(NULL)); //itianailze the seeds to rand

	get_inputs(length, min_dur, max_dur, max_due,  mute_per);

	genetic cm(length, min_dur, max_dur, max_due);



	sch = new int[length+1];
	orig_sch = new int[length+1];

	cm.generate_init_pool();
	cout <<" Initial job pool is created successfully " << endl;
	cout <<" Number of itartaions for the random generation of schedules " <<
	endl;

	cin >> iterations;
	log_data <<"Number of iteration for the random generation is "
		<<iterations <<endl;

	cm.random_schedules(iterations);

	cout <<" Total number of trials to repeat with each encoding "<< endl;
	cin >> trials;

	log_data <<" Each encoding is repeated "<< trials << " times"<<endl;

	cout <<" choose one of the following options " << endl;

	cin >> option;


	while (option != 0)
	{	switch (option){

		case 1:
			cm.generate_init_pool();
			break;
		case 2:
			log_data <<" Starting the trial with Random Key "<<endl;
			for (i= 1; i <= trials; i++)
			{
				cm.copy_pool(random_key);
				cm.converge(mute_per);
				log_data <<" The best cost at trial " << i << " is " 
				<< cm.best_cost_so_far() << endl;
			}
			break;
		case 3:
			log_data <<" Starting the trial with duration"<<endl;
			for (i= 1; i <= trials; i++)
			{
				cm.copy_pool(duration);
				cm.converge(mute_per);
				log_data<<" The best cost at trial " << i << " is " 
				<< cm.best_cost_so_far() << endl;
			}
			break;

		case 4:
			cout <<" Enter the initail % of higher cost and the accepting
			percentage (<= 1) " << endl;
			cin >> per_cost >> prob ;
			log_data <<" Starting the trial with annealing "<<endl;

			for (i= 1; i <= trials; i++)
			{ 	cm.anneal(per_cost, prob, "anneal.data");
				log_data<<" The best cost at trial " << i << " is " 
				<< cm.best_cost_so_far() << endl;
			}
			break;

		case 5:
			cout <<"printing chromos pool "<< endl;
			cm.print_chromos_pool();
			break;

		case 6:
			cout <<"printing job pool "<< endl;
			cm.print_job_pool();
			break;

		case 7:
			cout <<" The best cost found so far is " << cm.best_cost_so_far() << endl;
			cout << " the best schedule is " << endl;
			cm.print_best_schedule();
			break;
		case 8:
			cout <<" The 1 st col is the duration and the 2nd coloumn is the due date " <<
			endl;
			cout << "the values are multiplied by (duration factor ) " << endl;
			cm.print_cost_matrix();
			break;
		case 9:
			cout <<" Enter the number of repeates for  annealing "<< endl;
			cin >> repeates;

			for (j =1; j <= repeates; j++)
			{ 	cout <<" Enter the initail % of higher cost and the accepting
				percentage (<= 1) " << endl;
				cin >> per_cost >> prob ;
				log_data <<" Starting the trial with annealing "<<endl;
				log_data <<" with per_cost "<< per_cost <<" probability
				"<<prob << endl;


				for (i= 1; i <= trials; i++)
				{ 	cm.anneal(per_cost, prob, annealdata[j]);
					log_data<<" The best cost at trial " << i << " is " 
					<< cm.best_cost_so_far() << endl;
				}
			}
			break;

		default:
			cout <<" 1: generate init schedule "<< endl;
			cout <<" 2: Generate the schedules with random key gene "<< endl;
			cout <<" 3: Generate the schedules with duration gene "<< endl;
			cout <<" 4: Generate the schedules using simulated annealing "<<
			endl;
			cout <<" 5: Print chromosome pool "<< endl;
			cout <<" 6: Print job pool "<< endl;
			cout <<" 7: Print the best cost and the best schedule "<< endl;
			cout <<" 8: Print the cost matrix "<< endl;
		}

	cout << " Enter your options " << endl;
	cin >> option;
	}
	close("duration.data");
	close("randomkey.data");
}



